<?php
defined('PF_VERSION') OR exit('Access denied');
define('PLUGIN_USER', __('User', 'user'));

class User_Plugin extends Pf_Plugin {

    public $name = PLUGIN_USER;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the Users description';

    public function activate() {
        $db = Pf::database();
        $sql = "DROP TABLE IF EXISTS `pf_users`";
        $db->query($sql);
        $sql = "DROP TABLE IF EXISTS `pf_role`";
        $db->query($sql);
        $sql = "CREATE TABLE `pf_users` (
                        `id` int(11) NOT NULL AUTO_INCREMENT,
                        `user_name` varchar(20) NOT NULL,
                        `user_displayname` varchar(30) NOT NULL,
                        `user_password` varchar(40) NOT NULL,
                        `user_email` varchar(50) NOT NULL,
                        `user_role` smallint(6) NOT NULL,
                        `user_registered_date` timestamp NULL DEFAULT NULL,
                        `user_activation_key` varchar(10) NOT NULL,
                        `user_activation` tinyint(4) NOT NULL DEFAULT '2',
                        `user_tmpass` varchar(15) DEFAULT NULL,
                        `user_login_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
                        `user_login_ip` varchar(20) DEFAULT NULL,
                        `user_avatar` varchar(100) DEFAULT NULL,
                        `login_attemp` timestamp NULL DEFAULT NULL,
                        PRIMARY KEY (`id`)
                       ) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;";
        $db->query($sql);
        $sql = "
                CREATE TABLE `pf_role` (
                        `id` int(11) NOT NULL AUTO_INCREMENT,
                        `role_name` varchar(20) CHARACTER SET latin1 NOT NULL,
                        PRIMARY KEY (`id`)
                       ) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
                      ";
        $db->query($sql);
        $db->insert_bulk('pf_users', array('id', 'role_name'), array(
            array('1', 'Administrator'),
            array('2', 'Editor'),
            array('3', 'Author'),
            array('4', 'Contributor'),
            array('5', 'User'),
        ));
    }

    function deactivate() {
        $db = Pf::database();
        $sql = "DROP TABLE IF EXISTS `pf_users`";
        $db->query($sql);
        $sql = "DROP TABLE IF EXISTS `pf_role`";
        $db->query($sql);
    }

    public function public_init() {
        $shortcode = Pf::shortcode();
        $shortcode->add('users', array($this, 'user_func'));
    }

    function user_func($atts, $content = null, $code = '') {
        require_once abs_plugin_path(__FILE__) ."/user/class/pf-user-security.php";
        ob_start();
        require_once abs_plugin_path(__FILE__) ."/user/class/pf-role.php";
        require abs_plugin_path(__FILE__) . "/user/public/user-public.php";

        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }

    public function admin_init() {
        require_once ABSPATH . '/includes/common/plugin/utiles/pf-plugin-singleton.php';
        require_once abs_plugin_path(__FILE__) . "/user/user-config.php";
        if (is_admin())
        $this->admin_menu('fa fa-user', __('User', 'user'), 'users', 'plugin_user');
    }

    function plugin_user() {
        $user_status = array(
            1 => __('Yes', 'user'),
            2 => __('No', 'user')
        );
        $action = isset($_GET ['act']) ? $_GET ['act'] : 'main';
        $a_act = array(
            'create',
            'edit',
            'main',
            'myprofile'
        );
        if (!in_array($action, $a_act)) {
            echo __('Access Denied!', 'user');
        } else {
            $this->js('user/assets/js.js', __FILE__);
            $this->css('admin/themes/default/assets/bootstrap-modal/css/animate.min.css');
            $this->css('admin/plugins/user/assets/users.css');
            $this->js('admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js');
            $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
            require_once ABSPATH . "/includes/common/plugin/helpers/helper.php";
            require_once ABSPATH . "/includes/common/plugin/utiles/pf-plugin-session.php";
            require_once ABSPATH . "/includes/common/plugin/utiles/pf-plugin-csrf.php";

            require_once abs_plugin_path(__FILE__) ."/user/class/pf-role.php";
            require_once abs_plugin_path(__FILE__) . "/user/class/mail-class.php";
            $role_list = new Pf_Role();
            $user_role = $role_list->get_list_role();
            if (is_admin() or $action=='myprofile') {
                require_once abs_plugin_path(__FILE__) . "/user/action/" . $action . ".php";
            } else
                echo __('Access Denied!', 'user');
        }
    }

}
